/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.common.util.EExtraCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;

public class ColouredCircleOptions
implements ParticleOptions {
    private final ParticleType<ColouredCircleOptions> particleType;
    private final int colour;
    private final Vec3 center;
    private final float radius;

    public ColouredCircleOptions(ParticleType<ColouredCircleOptions> particleType, int colour, Vec3 center, float radius) {
        this.particleType = particleType;
        this.colour = colour;
        this.radius = radius;
        this.center = center;
    }

    public static MapCodec<ColouredCircleOptions> codec(ParticleType<ColouredCircleOptions> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("colour").forGetter(data -> data.colour), (App)EExtraCodecs.VEC3.fieldOf("center").forGetter(data -> data.center), (App)Codec.FLOAT.fieldOf("radius").forGetter(data -> Float.valueOf(data.radius))).apply((Applicative)instance, (colour, center, radius) -> new ColouredCircleOptions(type, (int)colour, (Vec3)center, radius.floatValue())));
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ColouredCircleOptions> streamCodec(ParticleType<ColouredCircleOptions> type) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, data -> data.colour, EExtraCodecs.STREAM_VEC3, data -> data.center, (StreamCodec)ByteBufCodecs.FLOAT, data -> Float.valueOf(data.radius), (colour, center, radius) -> new ColouredCircleOptions(type, (int)colour, (Vec3)center, radius.floatValue()));
    }

    public float getRed() {
        return (float)FastColor.ARGB32.red((int)this.colour) / 255.0f;
    }

    public float getGreen() {
        return (float)FastColor.ARGB32.green((int)this.colour) / 255.0f;
    }

    public float getBlue() {
        return (float)FastColor.ARGB32.blue((int)this.colour) / 255.0f;
    }

    public float getAlpha() {
        return (float)FastColor.ARGB32.alpha((int)this.colour) / 255.0f;
    }

    public float getRadius() {
        return this.radius;
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public ParticleType<?> getType() {
        return this.particleType;
    }
}

