/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;

public class ColourOptions
implements ParticleOptions {
    private final ParticleType<ColourOptions> particleType;
    private final int colour;

    public ColourOptions(ParticleType<ColourOptions> particleType, int colour) {
        this.particleType = particleType;
        this.colour = colour;
    }

    public static MapCodec<ColourOptions> codec(ParticleType<ColourOptions> type) {
        return Codec.INT.xmap(i -> new ColourOptions(type, (int)i), o -> o.colour).fieldOf("colour");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ColourOptions> streamCodec(ParticleType<ColourOptions> type) {
        return ByteBufCodecs.INT.map(i -> new ColourOptions(type, (int)i), o -> o.colour);
    }

    public float getRed() {
        return (float)FastColor.ARGB32.red((int)this.colour) / 255.0f;
    }

    public float getGreen() {
        return (float)FastColor.ARGB32.green((int)this.colour) / 255.0f;
    }

    public float getBlue() {
        return (float)FastColor.ARGB32.blue((int)this.colour) / 255.0f;
    }

    public float getAlpha() {
        return (float)FastColor.ARGB32.alpha((int)this.colour) / 255.0f;
    }

    public ParticleType<?> getType() {
        return this.particleType;
    }
}

