/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class SkyWrathSeedParticle
extends NoRenderParticle {
    private static final double xSpread = 0.3;
    private static final double ySpread = 0.3;
    private static final double zSpread = 0.3;

    protected SkyWrathSeedParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.lifetime = 60;
        this.hasPhysics = false;
    }

    public void tick() {
        if (this.age++ < this.lifetime) {
            if (this.age % 3 == 0) {
                for (int a = 0; a < 360; a += 20) {
                    double angle = Math.toRadians(a);
                    double cx = this.x + Math.sin(angle) * 5.0 + Math.random() * 0.3;
                    double cy = this.y + Math.random() * 0.3;
                    double cz = this.z + Math.cos(angle) * 5.0 + Math.random() * 0.3;
                    this.level.addParticle((ParticleOptions)new DelayedPosOptions(EParticleTypes.SKY_WRATH.get(), new Vec3(this.x, this.y, this.z), 180 - this.age), cx, cy, cz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SkyWrathSeedParticle(level, x, y, z);
        }
    }
}

