/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class SkyWrathParticle
extends TextureSheetParticle {
    private static final double EXPLODE_SPEED = 0.7;
    private static final double ATTRACT_SPEED = 0.02;
    private static final double ORBIT_SPEED = 20.0;
    private final Vec3 center;
    private final int explodeTicks;

    protected SkyWrathParticle(ClientLevel level, double x, double y, double z, Vec3 center, int explodeTicks) {
        super(level, x, y, z);
        this.center = center;
        this.explodeTicks = explodeTicks;
        this.alpha = 0.0f;
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age < this.explodeTicks) {
            if (this.alpha < 1.0f) {
                this.alpha += 0.3f;
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                }
            }
            Vec3 relativePos = new Vec3(this.x, this.y, this.z).subtract(this.center);
            double radius = relativePos.length() - 0.02;
            double a = Math.toRadians(20.0);
            Vec3 rotatedRelativePos = new Vec3(relativePos.x * Math.cos(a) - relativePos.z * Math.sin(a), relativePos.y, relativePos.z * Math.sin(a) + relativePos.x * Math.cos(a));
            Vec3 newPos = rotatedRelativePos.normalize().scale(radius).add(this.center);
            this.x = newPos.x();
            this.y = newPos.y();
            this.z = newPos.z();
        } else {
            Vec3 velocity = new Vec3(this.x, this.y, this.z).subtract(this.center).normalize().scale(0.7);
            this.xd = velocity.x();
            this.yd = velocity.y();
            this.zd = velocity.z();
            this.move(this.xd, this.yd, this.zd);
            this.alpha -= 0.06f;
            if (this.alpha < 0.0f) {
                this.remove();
            }
        }
        ++this.age;
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<DelayedPosOptions> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(DelayedPosOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SkyWrathParticle particle = new SkyWrathParticle(level, x, y, z, data.getCenter(), data.getDelay());
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

