/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.ColouredCircleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class RepellingParticle
extends TextureSheetParticle {
    private static final double REPEL_SPEED = 0.3;
    private final Vec3 center;

    protected RepellingParticle(ClientLevel level, double x, double y, double z, float red, float green, float blue, Vec3 center) {
        super(level, x, y, z);
        this.center = center;
        this.alpha = 0.0f;
        this.lifetime = 60;
        this.hasPhysics = false;
        this.quadSize = 0.1f;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age < this.lifetime) {
            if (this.alpha < 1.0f) {
                this.alpha += 0.2f;
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                }
            }
        } else if (this.alpha > 0.0f) {
            this.alpha -= 0.02f;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
                this.remove();
            }
        }
        Vec3 velocity = new Vec3(this.x, this.y, this.z).subtract(this.center).normalize().scale(0.3);
        this.xd = velocity.x();
        this.yd = velocity.y();
        this.zd = velocity.z();
        this.move(this.xd, this.yd, this.zd);
        ++this.age;
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<ColouredCircleOptions> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(ColouredCircleOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RepellingParticle particle = new RepellingParticle(level, x, y, z, data.getRed(), data.getGreen(), data.getBlue(), data.getCenter());
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

