/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class RemoveCurseSeedParticle
extends NoRenderParticle {
    private static final double RADIUS = 4.5;
    public static final double ORB_RADIUS = 1.0;

    protected RemoveCurseSeedParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.lifetime = 300;
        this.hasPhysics = false;
    }

    public void tick() {
        if (this.age++ < this.lifetime) {
            if (this.age < 200) {
                this.spawnParticle();
                if (Math.random() < 0.5) {
                    this.spawnParticle();
                }
            }
            if (this.age > 40) {
                double dx = (Math.random() - 0.5) * 1.0 / 1.5;
                double dy = (Math.random() - 0.5) * 1.0 / 1.5;
                double dz = (Math.random() - 0.5) * 1.0 / 1.5;
                this.level.addParticle((ParticleOptions)ParticleTypes.SOUL, this.x + dx, this.y + dy, this.z + dz, 0.0, 0.0, 0.0);
            }
        } else {
            this.remove();
        }
    }

    private void spawnParticle() {
        double cx = Enchanted.RANDOM.nextGaussian();
        double cy = Enchanted.RANDOM.nextGaussian();
        double cz = Enchanted.RANDOM.nextGaussian();
        double c = Math.cbrt(Math.random());
        Vec3 pos = new Vec3(cx, cy, cz).normalize().scale(c * 4.5).add(this.x, this.y, this.z);
        this.level.addParticle((ParticleOptions)new DelayedPosOptions(EParticleTypes.REMOVE_CURSE.get(), new Vec3(this.x, this.y, this.z), 300 - this.age + Enchanted.RANDOM.nextInt(11)), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RemoveCurseSeedParticle(level, x, y, z);
        }
    }
}

