/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class RemoveCurseParticle
extends TextureSheetParticle {
    private static final double RAISE_SPEED = 0.7;
    private static final double RAISE_ACCELERATION = 0.05;
    private static final double ATTRACT_SPEED = 0.06;
    private final int raiseTicks;
    private final Vec3 center;

    protected RemoveCurseParticle(ClientLevel level, double x, double y, double z, Vec3 center, int raiseTicks) {
        super(level, x, y, z);
        this.center = center;
        this.raiseTicks = raiseTicks;
        this.alpha = 0.0f;
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.raiseTicks) {
            Vec3 relativePos;
            if (this.alpha < 1.0f) {
                this.alpha += 0.05f;
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                }
            }
            if ((relativePos = new Vec3(this.x, this.y, this.z).subtract(this.center)).length() <= 1.0) {
                this.xd = 0.0;
                this.yd = 0.0;
                this.zd = 0.0;
            } else {
                Vec3 velocity = relativePos.normalize().scale(-0.06);
                this.xd = velocity.x();
                this.yd = velocity.y();
                this.zd = velocity.z();
            }
        } else if (this.alpha > 0.0f) {
            this.alpha -= 0.05f;
            this.xd = 0.0;
            this.yd = Math.min(this.yd + 0.05, 0.7);
            this.zd = 0.0;
        } else {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<DelayedPosOptions> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(DelayedPosOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RemoveCurseParticle particle = new RemoveCurseParticle(level, x, y, z, data.getCenter(), data.getDelay());
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

