/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.particles.types.DoubleOptions;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;

public class ProtectionSeedParticle
extends NoRenderParticle {
    private final float radius;

    protected ProtectionSeedParticle(ClientLevel level, double x, double y, double z, double radius) {
        super(level, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.hasPhysics = false;
        this.radius = (float)radius;
    }

    public void tick() {
        float increment = 1.0f / this.radius;
        for (float y = 0.0f; y <= (float)Math.PI * 2 + increment / 2.0f; y += increment) {
            for (float p = 0.0f; p <= (float)Math.PI * 2 + increment / 2.0f; p += increment) {
                if (!(Math.random() < 0.025)) continue;
                float cosP = Mth.cos((float)p);
                double cx = (double)(Mth.sin((float)y) * cosP * this.radius) + this.x + (Math.random() - 0.5);
                double cy = (double)(Mth.sin((float)p) * this.radius) + this.y + (Math.random() - 0.5);
                double cz = (double)(Mth.cos((float)y) * cosP * this.radius) + this.z + (Math.random() - 0.5);
                this.level.addParticle((ParticleOptions)EParticleTypes.PROTECTION.get(), cx, cy, cz, 0.0, 0.0, 0.0);
            }
        }
        if (++this.age > 20) {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<DoubleOptions> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(DoubleOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ProtectionSeedParticle(level, x, y, z, data.getValue());
        }
    }
}

