/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class ProtectionParticle
extends TextureSheetParticle {
    protected ProtectionParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.lifetime = 30;
        this.quadSize = 0.1f;
        this.alpha = 0.0f;
        this.hasPhysics = false;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.alpha -= 0.04f;
            if (this.alpha <= 0.0f) {
                this.remove();
            }
        } else if (this.alpha < 1.0f) {
            this.alpha += 0.04f;
            if (this.alpha > 1.0f) {
                this.alpha = 1.0f;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ProtectionParticle particle = new ProtectionParticle(level, x, y, z);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

