/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;

public class ImprisonmentCageSeedParticle
extends NoRenderParticle {
    protected ImprisonmentCageSeedParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.hasPhysics = false;
    }

    public void tick() {
        for (int a = 0; a < 360; ++a) {
            double angle = Math.toRadians(a);
            double cx = this.x + Math.sin(angle) * 3.3;
            double cy = this.y;
            double cz = this.z + Math.cos(angle) * 3.3;
            this.level.addParticle((ParticleOptions)EParticleTypes.IMPRISONMENT_CAGE.get(), cx, cy, cz, 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)EParticleTypes.IMPRISONMENT_CAGE.get(), cx, cy + 4.0, cz, 0.0, 0.0, 0.0);
            if (a % 20 != 0) continue;
            for (int i = 0; i < 40; ++i) {
                this.level.addParticle((ParticleOptions)EParticleTypes.IMPRISONMENT_CAGE.get(), cx, cy += 0.1, cz, 0.0, 0.0, 0.0);
            }
        }
        this.remove();
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ImprisonmentCageSeedParticle(level, x, y, z);
        }
    }
}

