/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class CurseSeedParticle
extends NoRenderParticle {
    private static final double RADIUS = 1.5;
    private static final double Y_INCREMENT = 0.2;
    private double yOffset = 0.0;

    protected CurseSeedParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.lifetime = 20;
    }

    public void tick() {
        if (this.age++ < this.lifetime) {
            float angle = (float)(this.age * 20) * ((float)Math.PI / 180);
            for (int i = 0; i < 20; i += 5) {
                double cx = this.x + (double)Mth.sin((float)(angle + (float)i)) * 1.5;
                double cy = this.y + Math.random() + this.yOffset;
                double cz = this.z + (double)Mth.cos((float)(angle + (float)i)) * 1.5;
                this.level.addParticle((ParticleOptions)ParticleTypes.SOUL, cx, cy, cz, 0.0, 0.0, 0.0);
            }
            this.yOffset += 0.2;
        } else {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CurseSeedParticle(level, x, y, z);
        }
    }
}

