/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.ColouredCircleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CircleMagicParticle
extends TextureSheetParticle {
    public static final double ANGLE = 2.0;
    private final float radius;
    private final double xStart;
    private final double zStart;

    protected CircleMagicParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float red, float green, float blue, Vec3 center, float radius) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.radius = radius;
        this.quadSize = 0.06f;
        this.age = 0;
        this.lifetime = 60;
        this.hasPhysics = false;
        this.xStart = center.x;
        this.zStart = center.z;
        this.xd = 0.0;
        this.yd = 0.04;
        this.zd = 0.0;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.alpha -= 0.01f;
            if (this.alpha <= 0.0f) {
                this.remove();
            }
        }
        double angle = Math.toRadians(2.0);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        Vec3 newPos = new Vec3(cos * (this.x - this.xStart) - sin * (this.z - this.zStart), 0.0, sin * (this.x - this.xStart) + cos * (this.z - this.zStart)).normalize().scale((double)this.radius).add(this.xStart, 0.0, this.zStart);
        this.xd = newPos.x - this.x;
        this.zd = newPos.z - this.z;
        this.move(this.xd, this.yd, this.zd);
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<ColouredCircleOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Nullable
        public Particle createParticle(ColouredCircleOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CircleMagicParticle particle = new CircleMagicParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getRed(), data.getGreen(), data.getBlue(), data.getCenter(), data.getRadius());
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

