/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class CauldronCookParticle
extends TextureSheetParticle {
    public static final double ANGLE = 8.0;
    public static final double RADIUS_INCREASE = 0.005;
    private final int circleStart;
    private final double xStart;
    private final double zStart;
    private double currentRadius;

    protected CauldronCookParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float red, float green, float blue) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.rCol = Math.min(red + (float)(Enchanted.RANDOM.nextInt(40) - 20) / 255.0f, 1.0f);
        this.gCol = Math.min(green + (float)(Enchanted.RANDOM.nextInt(40) - 20) / 255.0f, 1.0f);
        this.bCol = Math.min(blue + (float)(Enchanted.RANDOM.nextInt(40) - 20) / 255.0f, 1.0f);
        this.scale(this.random.nextFloat() * 0.6f);
        this.age = 0;
        this.lifetime = 80;
        this.hasPhysics = false;
        this.circleStart = Enchanted.RANDOM.nextInt(5) + 10;
        this.xStart = x;
        this.zStart = z;
        this.xd = Math.random() * 0.005 - 0.0025;
        this.yd = 0.04;
        this.zd = Math.random() * 0.005 - 0.0025;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.alpha -= 0.1f;
            if (this.alpha <= 0.0f) {
                this.remove();
            }
        }
        if (this.age >= this.circleStart) {
            if (this.age == this.circleStart) {
                this.xd = 0.0;
                this.yd = 0.0;
                this.zd = 0.0;
                double xOffset = this.x - this.xStart;
                double zOffset = this.z - this.zStart;
                this.currentRadius = Math.sqrt(xOffset * xOffset + zOffset * zOffset);
            }
            this.currentRadius += 0.005;
            double angle = Math.toRadians(8.0);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            Vec3 newPos = new Vec3(cos * (this.x - this.xStart) - sin * (this.z - this.zStart), 0.0, sin * (this.x - this.xStart) + cos * (this.z - this.zStart)).normalize().scale(this.currentRadius).add(this.xStart, 0.0, this.zStart);
            this.x = newPos.x;
            this.z = newPos.z;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<ColourOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ColourOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronCookParticle particle = new CauldronCookParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getRed(), data.getGreen(), data.getBlue());
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

