/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class CauldronBrewParticle
extends TextureSheetParticle {
    protected CauldronBrewParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float red, float green, float blue) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.rCol = Math.min(red + (float)(Enchanted.RANDOM.nextInt(20) - 10) / 255.0f, 1.0f);
        this.gCol = Math.min(green + (float)(Enchanted.RANDOM.nextInt(20) - 10) / 255.0f, 1.0f);
        this.bCol = Math.min(blue + (float)(Enchanted.RANDOM.nextInt(20) - 10) / 255.0f, 1.0f);
        this.scale(this.random.nextFloat() * 0.4f);
        this.lifetime = 200;
        this.gravity = 0.02f;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.93;
            this.yd *= 0.93;
            this.zd *= 0.93;
            if (this.onGround) {
                this.alpha -= 0.1f;
                if (this.alpha <= 0.0f) {
                    this.remove();
                }
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<ColourOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ColourOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronBrewParticle particle = new CauldronBrewParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getRed(), data.getGreen(), data.getBlue());
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

