/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class BoilingParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected BoilingParticle(ClientLevel level, double x, double y, double z, float red, float green, float blue, SpriteSet sprites) {
        super(level, x, y, z);
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.sprites = sprites;
        this.scale(Enchanted.RANDOM.nextFloat() * 0.4f);
        this.lifetime = Enchanted.RANDOM.nextInt(10) + 5;
        this.setSpriteFromAge(sprites);
        this.hasPhysics = false;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<ColourOptions> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ColourOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BoilingParticle(level, x, y, z, data.getRed(), data.getGreen(), data.getBlue(), this.sprites);
        }
    }
}

