/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class BindFamiliarSeedParticle
extends NoRenderParticle {
    private static final double RADIUS = 4.5;
    public static final double ORB_RADIUS = 0.7;

    protected BindFamiliarSeedParticle(ClientLevel pLevel, double x, double y, double z) {
        super(pLevel, x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
        this.lifetime = 300;
        this.hasPhysics = false;
    }

    public void tick() {
        if (this.age++ < this.lifetime) {
            if (this.age < 200) {
                this.spawnParticle();
                this.spawnParticle();
            }
        } else {
            this.remove();
        }
    }

    private void spawnParticle() {
        double cx = Enchanted.RANDOM.nextGaussian();
        double cy = Enchanted.RANDOM.nextGaussian();
        double cz = Enchanted.RANDOM.nextGaussian();
        double c = Math.cbrt(Math.random());
        Vec3 pos = new Vec3(cx, cy, cz).normalize().scale(c * 4.5).add(this.x, this.y, this.z);
        int fallTicks = 300 - this.age;
        if (Enchanted.RANDOM.nextFloat() < 0.3f) {
            fallTicks = Enchanted.RANDOM.nextInt(fallTicks);
        }
        this.level.addParticle((ParticleOptions)new DelayedPosOptions(EParticleTypes.BIND_FAMILIAR.get(), new Vec3(this.x, this.y, this.z), fallTicks), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprites) {
        }

        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BindFamiliarSeedParticle(level, x, y, z);
        }
    }
}

