/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles;

import net.favouriteless.enchanted.client.EParticleRenderTypes;
import net.favouriteless.enchanted.client.particles.types.DelayedPosOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class BindFamiliarParticle
extends TextureSheetParticle {
    private static final double EXPLODE_SPEED = 0.6;
    private static final double ATTRACT_SPEED = 0.06;
    private final SpriteSet sprites;
    private final int fallTicks;
    private final Vec3 center;

    protected BindFamiliarParticle(ClientLevel level, double x, double y, double z, Vec3 center, int fallTicks, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.center = center;
        this.fallTicks = fallTicks;
        this.alpha = 0.0f;
        this.quadSize = 0.125f * (this.random.nextFloat() * 0.2f + 0.5f);
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = f * 0.9f;
        this.gCol = f * 0.3f;
        this.bCol = f;
        this.hasPhysics = false;
        this.lifetime = 100;
        this.friction = 0.85f;
        this.gravity = 0.1f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        Vec3 relativePos = new Vec3(this.x, this.y, this.z).subtract(this.center);
        if (this.age++ < this.fallTicks) {
            if (this.alpha < 1.0f) {
                this.alpha += 0.05f;
                if (this.alpha > 1.0f) {
                    this.alpha = 1.0f;
                }
            }
            if (relativePos.length() <= 0.7) {
                this.xd = 0.0;
                this.yd = 0.0;
                this.zd = 0.0;
            } else {
                Vec3 velocity = relativePos.normalize().scale(-0.06);
                this.xd = velocity.x();
                this.yd = velocity.y();
                this.zd = velocity.z();
            }
        } else {
            if (this.age == this.fallTicks + 1) {
                Vec3 velocity = relativePos.normalize().scale(0.6);
                this.xd = velocity.x();
                this.yd = velocity.y();
                this.zd = velocity.z();
                this.hasPhysics = true;
            }
            if (this.alpha > 0.0f) {
                this.alpha -= 0.05f;
                this.xd *= (double)this.friction;
                this.yd -= (double)this.gravity;
                this.zd *= (double)this.friction;
            } else {
                this.remove();
            }
        }
        this.setSpriteFromAgeWrapped();
        this.move(this.xd, this.yd, this.zd);
    }

    private void setSpriteFromAgeWrapped() {
        this.setSprite(this.sprites.get(this.age % this.lifetime, this.lifetime));
    }

    public ParticleRenderType getRenderType() {
        return EParticleRenderTypes.translucentParticle();
    }

    public static class Factory
    implements ParticleProvider<DelayedPosOptions> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(DelayedPosOptions data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BindFamiliarParticle particle = new BindFamiliarParticle(level, x, y, z, data.getCenter(), data.getDelay(), this.sprite);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

