/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.taglock;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.favouriteless.enchanted.api.taglock.IBedTaglock;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class BedTaglockSavedData
extends SavedData {
    private static final String NAME = Enchanted.savedDataName("bed_taglocks");
    private final Map<BlockPos, IBedTaglock> entries = new HashMap<BlockPos, IBedTaglock>();

    public IBedTaglock getEntry(BlockEntity bed) {
        return this.getEntry(bed.getBlockPos());
    }

    public static BedTaglockSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (BedTaglockSavedData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(BedTaglockSavedData::new, BedTaglockSavedData::load, null), NAME);
        }
        throw new RuntimeException("Game attempted to load serverside taglock (bed) data from a clientside world.");
    }

    private IBedTaglock getEntry(BlockPos pos) {
        return this.entries.computeIfAbsent(pos, _pos -> new BedTaglockImpl());
    }

    private static BedTaglockSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        BedTaglockSavedData data = new BedTaglockSavedData();
        ListTag entryList = nbt.getList("entryList", 10);
        for (Tag e : entryList) {
            CompoundTag entryNbt = (CompoundTag)e;
            data.getEntry(BlockPos.of((long)entryNbt.getLong("key"))).deserialize(entryNbt);
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        this.entries.forEach((pos, data) -> {
            if (data.getData() != null) {
                CompoundTag entryTag = (CompoundTag)data.serialize();
                entryTag.putLong("key", pos.asLong());
            }
        });
        tag.put("entries", (Tag)list);
        return tag;
    }

    private static class BedTaglockImpl
    implements IBedTaglock {
        private EntityRefData data = null;

        private BedTaglockImpl() {
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.put("taglockData", (Tag)EntityRefData.CODEC.encode((Object)this.data, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
            return tag;
        }

        @Override
        public void deserialize(CompoundTag tag) {
            this.data = EntityRefData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("taglockData")).resultOrPartial(e -> Enchanted.LOG.error("Tried to load invalid Taglock data: '{}'", e)).orElse(null);
        }

        @Override
        @Nullable
        public EntityRefData getData() {
            return this.data;
        }

        @Override
        public void setData(@Nullable EntityRefData data) {
            this.data = data;
        }
    }
}

