/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.familiars;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.favouriteless.enchanted.api.familiars.FamiliarType;
import net.favouriteless.enchanted.api.familiars.IFamiliarEntry;
import net.favouriteless.enchanted.common.familiars.FamiliarTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class FamiliarSavedData
extends SavedData {
    private static final String NAME = "enchanted_familiars";
    private final Map<UUID, IFamiliarEntry> entries = new HashMap<UUID, IFamiliarEntry>();

    public IFamiliarEntry getEntry(UUID uuid) {
        return this.entries.get(uuid);
    }

    public void setFamiliar(UUID owner, FamiliarType<?, ?> type, TamableAnimal familiar) {
        this.entries.put(owner, new FamiliarEntry(type, familiar));
        this.setDirty();
    }

    public static FamiliarSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (FamiliarSavedData)serverLevel.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(FamiliarSavedData::new, FamiliarSavedData::load, null), NAME);
        }
        throw new RuntimeException("Game attempted to load serverside familiar data from a clientside world.");
    }

    private static FamiliarSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        FamiliarSavedData data = new FamiliarSavedData();
        for (String key : nbt.getAllKeys()) {
            CompoundTag tag = nbt.getCompound(key);
            FamiliarEntry entry = new FamiliarEntry(FamiliarTypes.get(ResourceLocation.parse((String)tag.getString("type"))), tag.getUUID("uuid"), tag.getCompound("nbt"), tag.getBoolean("isDismissed"));
            data.entries.put(UUID.fromString(key), entry);
        }
        return data;
    }

    public CompoundTag save(@NotNull CompoundTag nbt, HolderLookup.Provider provider) {
        for (UUID uuid : this.entries.keySet()) {
            CompoundTag tag = new CompoundTag();
            IFamiliarEntry entry = this.entries.get(uuid);
            if (entry == null) continue;
            tag.putUUID("uuid", entry.getUUID());
            tag.putString("type", entry.getType().getId().toString());
            tag.put("nbt", (Tag)entry.getNbt());
            tag.putBoolean("isDismissed", entry.isDismissed());
            nbt.put(uuid.toString(), (Tag)tag);
        }
        return nbt;
    }

    public static class FamiliarEntry
    implements IFamiliarEntry {
        private final FamiliarType<?, ?> type;
        private UUID uuid;
        private CompoundTag nbt;
        private boolean isDismissed = false;

        private FamiliarEntry(FamiliarType<?, ?> type, TamableAnimal familiar) {
            this.uuid = familiar.getUUID();
            this.type = type;
            this.setNbt(familiar.saveWithoutId(new CompoundTag()));
        }

        private FamiliarEntry(FamiliarType<?, ?> type, UUID uuid, CompoundTag nbt, boolean isDismissed) {
            this.uuid = uuid;
            this.type = type;
            this.isDismissed = isDismissed;
            this.setNbt(nbt);
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public FamiliarType<?, ?> getType() {
            return this.type;
        }

        @Override
        public CompoundTag getNbt() {
            return this.nbt;
        }

        @Override
        public void setNbt(CompoundTag nbt) {
            this.nbt = nbt.copy();
            this.nbt.remove("UUID");
        }

        @Override
        public boolean isDismissed() {
            return this.isDismissed;
        }

        @Override
        public void setDismissed(boolean value) {
            this.isDismissed = value;
        }
    }
}

