/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.datagen.providers;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.favouriteless.enchanted.common.altar.PowerProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class PowerProvidersProvider
implements DataProvider {
    private final String modId;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected PowerProvidersProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.modId = modId;
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "enchanted/altar");
        this.registries = registries;
    }

    protected abstract void buildBlocks(HolderLookup.Provider var1, TriConsumer<Block, Integer, Integer> var2);

    protected abstract void buildTags(HolderLookup.Provider var1, TriConsumer<TagKey<Block>, Integer, Integer> var2);

    public final CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        HashSet set = Sets.newHashSet();
        ArrayList generated = new ArrayList();
        this.buildBlocks(registries, (TriConsumer<Block, Integer, Integer>)((TriConsumer)(block, power, limit) -> {
            ResourceLocation id = this.getId((Block)block);
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate " + this.getName() + ": " + String.valueOf(id));
            }
            generated.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, PowerProvider.CODEC, (Object)new PowerProvider((int)power, (int)limit), (Path)this.pathProvider.json(id)));
        }));
        this.buildTags(registries, (TriConsumer<TagKey<Block>, Integer, Integer>)((TriConsumer)(tag, power, limit) -> {
            ResourceLocation id = this.getId((TagKey<Block>)tag);
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate " + this.getName() + ": " + String.valueOf(id));
            }
            generated.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, PowerProvider.CODEC, (Object)new PowerProvider((int)power, (int)limit), (Path)this.pathProvider.json(id)));
        }));
        return CompletableFuture.allOf((CompletableFuture[])generated.toArray(CompletableFuture[]::new));
    }

    private ResourceLocation getId(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath()));
    }

    private ResourceLocation getId(TagKey<Block> tag) {
        ResourceLocation id = tag.location();
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("tag/" + id.getPath()));
    }

    public String getName() {
        return "Enchanted PowerProvider[" + this.modId + "]";
    }
}

