/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.datagen.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.favouriteless.enchanted.common.mutandis.MutagenInfo;
import net.favouriteless.enchanted.datagen.providers.SimpleCodecProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public abstract class MutagenInfoProvider
extends SimpleCodecProvider<MutagenInfo> {
    private final String modId;
    private final Map<Block, MutagenInfo> mutagens = new HashMap<Block, MutagenInfo>();

    protected MutagenInfoProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output.createPathProvider(PackOutput.Target.DATA_PACK, "enchanted/mutagens"), registries, MutagenInfo.CODEC);
        this.modId = modId;
    }

    protected abstract void buildMutagens();

    @Override
    protected final void build(HolderLookup.Provider registries, BiConsumer<ResourceLocation, MutagenInfo> output) {
        this.buildMutagens();
        this.mutagens.forEach((block, info) -> output.accept(BuiltInRegistries.BLOCK.getKey(block), (MutagenInfo)info));
    }

    protected void add(Block result, Block mutee, boolean extremis, int weight, Block ... mutagens) {
        this.mutagens.computeIfAbsent(mutee, k -> new MutagenInfo(new ArrayList<MutagenInfo.MutagenSet>())).sets().add(MutagenInfo.MutagenSet.of(result, extremis, weight, mutagens));
    }

    protected void add(Block result, Supplier<? extends Block> mutee, boolean extremis, int weight, Block ... mutagens) {
        this.add(result, mutee.get(), extremis, weight, mutagens);
    }

    protected void add(Supplier<? extends Block> result, Supplier<? extends Block> mutee, boolean extremis, int weight, Block ... mutagens) {
        this.add(result.get(), mutee.get(), extremis, weight, mutagens);
    }

    protected void add(Supplier<? extends Block> result, Block mutee, boolean extremis, int weight, Block ... mutagens) {
        this.add(result.get(), mutee, extremis, weight, mutagens);
    }

    public String getName() {
        return "Enchanted MutagenInfo[" + this.modId + "]";
    }
}

