/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.datagen.builders.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.favouriteless.enchanted.api.datagen.builders.recipe.ERecipeBuilder;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.recipes.DistillingRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DistillingRecipeBuilder
extends ERecipeBuilder {
    private final List<ItemStack> inputs;
    private final List<ItemStack> results = new ArrayList<ItemStack>();
    private int duration = 300;
    private int power = 750;

    private DistillingRecipeBuilder(List<ItemStack> inputs) {
        super("distilling");
        this.inputs = inputs;
    }

    public static DistillingRecipeBuilder create(ItemStack ... inputs) {
        if (inputs.length > 3) {
            throw new IllegalStateException("Distillery recipes cannot have more than 3 inputs.");
        }
        return new DistillingRecipeBuilder(List.of(inputs));
    }

    public static DistillingRecipeBuilder create(ItemLike ... inputs) {
        if (inputs.length > 3) {
            throw new IllegalStateException("Distillery recipes cannot have more than 3 inputs.");
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemLike input : inputs) {
            stacks.add(new ItemStack(input));
        }
        return new DistillingRecipeBuilder(stacks);
    }

    public DistillingRecipeBuilder results(ItemStack ... results) {
        Collections.addAll(this.results, results);
        if (this.results.size() > 4) {
            throw new IllegalStateException("Distillery recipes cannot have more than 4 mutagens.");
        }
        return this;
    }

    public DistillingRecipeBuilder results(ItemLike ... results) {
        ItemStack[] stacks = new ItemStack[results.length];
        for (int i = 0; i < results.length; ++i) {
            stacks[i] = new ItemStack(results[i]);
        }
        Collections.addAll(this.results, stacks);
        if (this.results.size() > 4) {
            throw new IllegalStateException("Distillery recipes cannot have more than 4 mutagens.");
        }
        return this;
    }

    public DistillingRecipeBuilder duration(int duration) {
        if (duration < 1) {
            throw new IllegalArgumentException("Distillery recipes cannot have a duration smaller than 1.");
        }
        this.duration = duration;
        return this;
    }

    public DistillingRecipeBuilder power(int power) {
        if (power < 0) {
            throw new IllegalArgumentException("Distillery recipes cannot have a power smaller than 0.");
        }
        this.power = power;
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.results.get(0).getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        output.accept(id, (Recipe)new DistillingRecipe(this.inputs, this.results, this.duration, this.power), null);
    }

    @Override
    protected String getDefaultName() {
        StringBuilder name = new StringBuilder();
        for (ItemStack item : this.inputs) {
            if (item.getItem() == EItems.CLAY_JAR.get()) continue;
            name.append(BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getPath()).append("_");
        }
        name.deleteCharAt(name.length() - 1);
        return name.toString();
    }
}

