/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.datagen.builders.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.favouriteless.enchanted.api.datagen.builders.recipe.ERecipeBuilder;
import net.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import net.favouriteless.enchanted.common.recipes.KettleRecipe;
import net.favouriteless.enchanted.common.recipes.WitchCauldronRecipe;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CauldronTypeRecipeBuilder
extends ERecipeBuilder {
    private final CauldronTypeRecipeFactory<?> factory;
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();
    private final ItemStack result;
    private final int power;
    private int cookColour = 2954590;
    private int finalColour = 4856493;

    private CauldronTypeRecipeBuilder(String subfolder, CauldronTypeRecipeFactory<?> factory, ItemStack result, int power) {
        super(subfolder);
        this.power = power;
        this.result = result;
        this.factory = factory;
    }

    public static CauldronTypeRecipeBuilder cauldron(ItemStack result, int power) {
        return new CauldronTypeRecipeBuilder("witch_cauldron", WitchCauldronRecipe::new, result, power);
    }

    public static CauldronTypeRecipeBuilder kettle(ItemStack result, int power) {
        return new CauldronTypeRecipeBuilder("kettle", KettleRecipe::new, result, power);
    }

    public CauldronTypeRecipeBuilder inputs(ItemStack ... inputs) {
        Collections.addAll(this.inputs, inputs);
        return this;
    }

    public CauldronTypeRecipeBuilder inputs(ItemLike ... inputs) {
        for (ItemLike item : inputs) {
            this.inputs.add(item.asItem().getDefaultInstance());
        }
        return this;
    }

    public CauldronTypeRecipeBuilder cookColor(int colour) {
        this.cookColour = colour;
        return this;
    }

    public CauldronTypeRecipeBuilder finalColor(int colour) {
        this.finalColour = colour;
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        output.accept(id, this.factory.create(this.inputs, this.result, this.power, this.cookColour, this.finalColour), null);
    }

    @FunctionalInterface
    public static interface CauldronTypeRecipeFactory<T extends CauldronTypeRecipe> {
        public T create(List<ItemStack> var1, ItemStack var2, int var3, int var4, int var5);
    }
}

