/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.datagen.builders.recipe;

import java.util.Arrays;
import net.favouriteless.enchanted.api.datagen.builders.recipe.ERecipeBuilder;
import net.favouriteless.enchanted.common.recipes.ByproductRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ByproductRecipeBuilder
extends ERecipeBuilder {
    private final ItemStack result;
    private final ItemLike[] items;
    private final TagKey<Item> tag;

    private ByproductRecipeBuilder(ItemStack result, ItemLike[] items, TagKey<Item> tag) {
        super("byproduct");
        this.result = result;
        this.items = items;
        this.tag = tag;
    }

    public static ByproductRecipeBuilder create(ItemStack result, ItemLike ... itemLikes) {
        return new ByproductRecipeBuilder(result, itemLikes, null);
    }

    public static ByproductRecipeBuilder create(ItemStack result, ItemStack ... stacks) {
        return new ByproductRecipeBuilder(result, (ItemLike[])Arrays.stream(stacks).map(ItemStack::getItem).toArray(ItemLike[]::new), null);
    }

    public static ByproductRecipeBuilder create(ItemStack result, TagKey<Item> tag) {
        return new ByproductRecipeBuilder(result, null, tag);
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        output.accept(id, (Recipe)new ByproductRecipe(this.tag == null ? Ingredient.of((ItemLike[])this.items) : Ingredient.of(this.tag), this.result), null);
    }

    @Override
    protected String getDefaultName() {
        String prefix = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath();
        String suffix = this.tag != null ? this.tag.location().getPath() : BuiltInRegistries.ITEM.getKey((Object)this.items[0].asItem()).getPath();
        return prefix + "_" + suffix;
    }
}

