/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.curses;

import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public abstract class RandomCurse
extends Curse {
    private final int min;
    private final int max;
    private long nextUseTick = 0L;

    public RandomCurse(CurseType<?> type, int min, int max) {
        super(type);
        this.min = min;
        this.max = max;
    }

    @Override
    protected void onTick(ServerPlayer target, long ticks) {
        if (this.nextUseTick <= ticks) {
            this.execute(target);
            this.nextUseTick = ticks + Enchanted.RANDOM.nextLong((long)this.min * 20L, (long)this.max * 20L);
        }
    }

    protected abstract void execute(ServerPlayer var1);

    @Override
    protected void saveAdditional(CompoundTag nbt) {
        nbt.putLong("nextUse", this.nextUseTick);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt) {
        this.nextUseTick = nbt.getLong("nextUse");
    }
}

