/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.api.curses;

import java.lang.ref.WeakReference;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.ServerConfig;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.favouriteless.enchanted.common.init.ESoundEvents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class Curse {
    public final CurseType<?> type;
    public int strength;
    private UUID targetUUID;
    private WeakReference<ServerPlayer> target;
    private long ticks = 0L;
    private long nextWhisper = 0L;

    public Curse(CurseType<?> type) {
        this.type = type;
    }

    protected void onTick(ServerPlayer target, long ticks) {
    }

    protected void saveAdditional(CompoundTag nbt) {
    }

    protected void loadAdditional(CompoundTag nbt) {
    }

    public void onRemove(ServerPlayer target) {
    }

    public ServerPlayer getTarget() {
        return this.target != null ? (ServerPlayer)this.target.get() : null;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public void setTargetUUID(UUID targetUUID) {
        this.targetUUID = targetUUID;
        this.target = null;
    }

    public final void tick(ServerLevel level) {
        ServerPlayer target;
        if (this.getTarget() == null) {
            this.target = new WeakReference<ServerPlayer>(level.getServer().getPlayerList().getPlayer(this.targetUUID));
        }
        if ((target = this.getTarget()) != null) {
            this.onTick(target, this.ticks);
        }
        if (this.nextWhisper <= this.ticks) {
            this.whisper();
            int min = (Integer)ServerConfig.INSTANCE.curseWhisperMin.get();
            int max = (Integer)ServerConfig.INSTANCE.curseWhisperMax.get();
            this.nextWhisper = this.ticks + Enchanted.RANDOM.nextLong((long)min * 20L, (long)max * 20L);
        }
        ++this.ticks;
    }

    public final void remove(ServerLevel level) {
        ServerPlayer target;
        if (this.getTarget() == null) {
            this.target = new WeakReference<ServerPlayer>(level.getServer().getPlayerList().getPlayer(this.targetUUID));
        }
        if ((target = this.getTarget()) != null) {
            this.onRemove(target);
        }
    }

    private void whisper() {
        ServerPlayer target = this.getTarget();
        if (target == null) {
            return;
        }
        target.connection.send((Packet)new ClientboundSoundEntityPacket(ESoundEvents.CURSE_WHISPER, SoundSource.AMBIENT, (Entity)target, 0.1f, (float)Math.random() * 0.15f + 0.85f, Enchanted.RANDOM.nextLong()));
    }

    public final void save(CompoundTag nbt) {
        nbt.putString("type", this.type.getId().toString());
        nbt.putUUID("target", this.targetUUID);
        nbt.putLong("ticks", this.ticks);
        nbt.putInt("strength", this.strength);
        this.saveAdditional(nbt);
    }

    public final void load(CompoundTag nbt) {
        this.target = null;
        this.targetUUID = nbt.getUUID("target");
        this.ticks = nbt.getLong("ticks");
        this.strength = nbt.getInt("strength");
        this.loadAdditional(nbt);
    }
}

