/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import lyrellion.ars_elemancy.datagen.Datagen;
import lyrellion.ars_elemancy.registry.ModItems;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class AELootTables
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public AELootTables(DataGenerator dataGeneratorIn, CompletableFuture<HolderLookup.Provider> provider) {
        super(dataGeneratorIn.getPackOutput(), new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), provider);
    }

    public static LootPool.Builder POD_BUILDER(Item item, Block block) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)ArchfruitPod.AGE, 2)))));
    }

    @NotNull
    public String getOldName() {
        return "Ars Elemental Loot Tables";
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public List<Block> list = new ArrayList<Block>();

        protected BlockLootTable(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_249322_) {
            this.generate();
            HashSet<ResourceKey> set = new HashSet<ResourceKey>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceKey resourcelocation;
                if (!block.isEnabled(this.enabledFeatures) || (resourcelocation = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.map.remove(resourcelocation)) == null) continue;
                p_249322_.accept((ResourceKey<LootTable>)resourcelocation, loottable$builder);
            }
        }

        protected void generate() {
            HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
            Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
            Datagen.takeAll(blocks, b -> !(b.get() instanceof SummonBlock)).forEach(b -> this.registerDropSelf((Block)b.get()));
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.add(leaves, l_state -> this.createLeavesDrops((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.dropSelf(block);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return this.list;
        }
    }
}

