/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.common.items.caster_tools;

import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import lyrellion.ars_elemancy.api.item.ISchoolFocus;
import lyrellion.ars_elemancy.common.components.SchoolCasterTomeData;
import lyrellion.ars_elemancy.registry.ModRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ElemancyCasterTome
extends CasterTome
implements ISchoolFocus {
    private final SpellSchool school;

    public ElemancyCasterTome(Item.Properties properties, SpellSchool school) {
        super(properties.component(ModRegistry.E_TOME_CASTER, (Object)new SchoolCasterTomeData()));
        this.school = school;
    }

    @Override
    public SpellSchool getSchool() {
        return this.school;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        tooltip2.add((Component)Component.translatable((String)"tooltip.ars_elemancy.caster_tome"));
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @Override
    public double getDiscount() {
        return 0.0;
    }

    public static class ETomeResolver
    extends SpellResolver {
        private final SpellSchool school;

        public SpellSchool getSchool() {
            return this.school;
        }

        public ETomeResolver(SpellContext context, SpellSchool school) {
            super(context);
            this.school = school;
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.getItem());
        }

        public boolean hasFocus(Item item) {
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.school == focus.getSchool();
            }
            if (item == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return this.school == SpellSchools.MANIPULATION;
            }
            return super.hasFocus(item);
        }

        protected boolean enoughMana(LivingEntity entity) {
            Player player;
            boolean canCast;
            int totalCost = this.getResolveCost();
            ManaCap manaCap = CapabilityRegistry.getMana((LivingEntity)entity);
            if (manaCap == null) {
                return false;
            }
            boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || manaCap.getCurrentMana() == (double)manaCap.getMaxMana() || entity instanceof Player && (player = (Player)entity).isCreative();
            if (!(canCast || entity.getCommandSenderWorld().isClientSide || this.silent)) {
                PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.spell.no_mana"));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    Networking.sendToPlayerClient((CustomPacketPayload)new NotEnoughManaPacket(totalCost), (ServerPlayer)serverPlayer);
                }
            }
            return canCast;
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new ETomeResolver(context, this.getSchool());
        }
    }
}

