/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.components.item.KeyringContents;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientKeyringTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/background");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 20;
    private final KeyringContents contents;

    public ClientKeyringTooltip(KeyringContents contents) {
        this.contents = contents;
    }

    public int getHeight() {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 20 + 2;
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics graphics) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        graphics.blitSprite(BACKGROUND_SPRITE, pX, pY, this.backgroundWidth(), this.backgroundHeight());
        boolean isFull = this.contents.size() >= 64;
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int i1 = 0; i1 < i; ++i1) {
                int j1 = pX + i1 * 18 + 1;
                int k1 = pY + l * 20 + 1;
                this.renderSlot(j1, k1, k++, isFull, graphics, font);
            }
        }
    }

    private void renderSlot(int pX, int pY, int index, boolean isFull, GuiGraphics graphics, Font font) {
        if (index >= this.contents.size()) {
            this.blit(graphics, pX, pY, isFull ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            ItemStack itemstack = this.contents.getItemUnsafe(index);
            this.blit(graphics, pX, pY, Texture.SLOT);
            graphics.renderItem(itemstack, pX + 1, pY + 1, index);
            graphics.renderItemDecorations(font, itemstack, pX + 1, pY + 1);
        }
    }

    private void blit(GuiGraphics graphics, int x, int y, Texture texture) {
        graphics.blitSprite(texture.sprite, x, y, 0, texture.w, texture.h);
    }

    private int gridSizeX() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.contents.size() + 1.0)));
    }

    private int gridSizeY() {
        return (int)Math.ceil(((double)this.contents.size() + 1.0) / (double)this.gridSizeX());
    }

    static enum Texture {
        BLOCKED_SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/blocked_slot"), 18, 20),
        SLOT(ResourceLocation.withDefaultNamespace((String)"container/bundle/slot"), 18, 20);

        public final ResourceLocation sprite;
        public final int w;
        public final int h;

        private Texture(ResourceLocation sprite, int w, int h) {
            this.sprite = sprite;
            this.w = w;
            this.h = h;
        }
    }
}

