/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.vanilla;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.vanilla.StairBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StairsBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final StairBlock stairBlock;

    public StairsBlockItem(StairBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.stairBlock = blockIn;
    }

    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.stairBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)"domum_ornamentum.stair.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent component = (IMateriallyTexturedBlockComponent)this.stairBlock.getComponents().get(0);
        Block block = textureData.getTexturedComponents().getOrDefault(component.getId(), component.getDefault());
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.onlyone", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{BlockUtils.getHoverName(block)})}));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("avanilla");
    }
}

