/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.attachment.SpellData;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.registry.SpelledRegistry;
import com.mrbysco.spelled.registry.keyword.TypeKeyword;
import com.mrbysco.spelled.util.LevelHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.ServerChatEvent;

public class SpellUtil {
    public static Component manualCastSpell(ServerPlayer player, String spell, Component comp) {
        ServerChatEvent event = new ServerChatEvent(player, spell, comp);
        SpellUtil.castSpell(event);
        if (event.isCanceled()) {
            return null;
        }
        return event.getMessage();
    }

    public static void castSpell(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        SpelledAPI.getSpellDataCap((Player)player).ifPresent(data -> {
            KeywordRegistry registry = KeywordRegistry.instance();
            String message = event.getRawText().toLowerCase(Locale.ROOT);
            String[] wordArray = message.split("\\s+");
            List<String> words = Arrays.asList(wordArray);
            boolean validSpellFormation = SpellUtil.isValidSpellFormation(player, words);
            if (words.size() >= 2 && validSpellFormation) {
                if (SpellUtil.canCastSpell(player, words)) {
                    if (SpellUtil.isOnCooldown(player)) {
                        event.setCanceled(true);
                        return;
                    }
                    IKeyword lastKeyword = registry.getKeywordFromName(words.get(words.size() - 1));
                    ServerLevel level = player.serverLevel();
                    if (lastKeyword instanceof TypeKeyword) {
                        TypeKeyword typeKeyword = (TypeKeyword)lastKeyword;
                        SpellEntity spell = SpellUtil.constructEntity(player, typeKeyword.getType());
                        StringBuilder castText = new StringBuilder();
                        MutableComponent descriptionComponent = Component.literal((String)"");
                        int cooldown = -1;
                        for (int i = 0; i < words.size() - 1; ++i) {
                            IKeyword keyword = registry.getKeywordFromName(words.get(i));
                            if (keyword == null) continue;
                            cooldown += keyword.getSlots();
                            castText.append(keyword.getKeyword()).append(" ");
                            descriptionComponent.append(keyword.getDescription()).append((Component)Component.literal((String)" "));
                            int previous = i - 1;
                            if (previous >= 0 && previous < words.size() - 1) {
                                keyword.cast((Level)level, player, spell, registry.getKeywordFromName(words.get(previous)));
                                continue;
                            }
                            keyword.cast((Level)level, player, spell, null);
                        }
                        cooldown = Mth.clamp((int)cooldown, (int)1, (int)Integer.MAX_VALUE);
                        castText.append(lastKeyword.getKeyword());
                        MutableComponent castComponent = Component.literal((String)castText.toString());
                        descriptionComponent.append(typeKeyword.getDescription());
                        descriptionComponent.withStyle(ChatFormatting.GOLD);
                        castComponent.setStyle(event.getMessage().getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)descriptionComponent))).withStyle(ChatFormatting.GOLD);
                        MutableComponent finalMessage = Component.translatable((String)"spelled.spell.cast", (Object[])new Object[]{player.getDisplayName(), castComponent});
                        if (spell != null) {
                            if (!player.getAbilities().instabuild) {
                                SpelledAPI.setCooldown((Player)player, cooldown);
                                SpelledAPI.syncCap(player);
                            }
                            if (typeKeyword.getType() != TypeKeyword.Type.SELF) {
                                SpellUtil.shootSpell(player, spell);
                                level.addFreshEntity((Entity)spell);
                            } else {
                                spell.handleEntityHit((Entity)player);
                                spell.discard();
                            }
                        }
                        if ((Integer)SpelledConfig.COMMON.proximity.get() > 0) {
                            event.setCanceled(true);
                            List playerEntities = level.players();
                            for (ServerPlayer nearbyPlayer : playerEntities) {
                                if (!nearbyPlayer.getUUID().equals(player.getUUID()) && (nearbyPlayer.level().dimension() != level.dimension() || !(player.distanceToSqr((Entity)nearbyPlayer) <= (double)((Integer)SpelledConfig.COMMON.proximity.get()).intValue()))) continue;
                                nearbyPlayer.sendSystemMessage((Component)finalMessage, true);
                            }
                        } else {
                            event.setMessage((Component)finalMessage);
                        }
                    }
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    public static boolean isValidSpellFormation(ServerPlayer player, List<String> words) {
        ISpellData data = SpelledAPI.getSpellDataCap((Player)player).orElse(new SpellData());
        KeywordRegistry registry = KeywordRegistry.instance();
        for (String word : words) {
            if (!registry.containsKey(word)) {
                return false;
            }
            if (data.knowsKeyword(word)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCastSpell(ServerPlayer player, List<String> words) {
        ISpellData data = SpelledAPI.getSpellDataCap((Player)player).orElse(new SpellData());
        KeywordRegistry registry = KeywordRegistry.instance();
        if (player.getAbilities().instabuild) {
            return true;
        }
        int currentLevel = data.getLevel();
        if (currentLevel == 0) {
            MutableComponent finalMessage = Component.translatable((String)"spelled.spell.no_levels", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED);
            player.sendSystemMessage((Component)finalMessage);
            return false;
        }
        int maxLevelWord = 0;
        for (String word : words) {
            IKeyword keyword = registry.getKeywordFromName(word);
            if (keyword == null || keyword.getLevel() <= maxLevelWord) continue;
            maxLevelWord = keyword.getLevel();
        }
        if (maxLevelWord > currentLevel) {
            MutableComponent errorMessage = Component.translatable((String)"spelled.spell.insufficient_level", (Object[])new Object[]{player.getDisplayName(), maxLevelWord, currentLevel}).withStyle(ChatFormatting.RED);
            player.sendSystemMessage((Component)errorMessage);
            return false;
        }
        int maxWordCount = LevelHelper.getAllowedWordCount(currentLevel);
        if (maxWordCount > 0 && words.size() <= maxWordCount) {
            return true;
        }
        MutableComponent errorMessage = Component.translatable((String)"spelled.spell.too_many_words", (Object[])new Object[]{player.getDisplayName(), maxWordCount}).withStyle(ChatFormatting.RED);
        player.sendSystemMessage((Component)errorMessage);
        return false;
    }

    public static boolean isOnCooldown(ServerPlayer player) {
        ISpellData data = SpelledAPI.getSpellDataCap((Player)player).orElse(new SpellData());
        int cooldown = data.getCastCooldown();
        if (cooldown > 0) {
            MutableComponent finalMessage = Component.translatable((String)"spelled.spell.cooldown", (Object[])new Object[]{player.getDisplayName(), cooldown});
            player.sendSystemMessage((Component)finalMessage);
            return true;
        }
        return false;
    }

    public static SpellEntity constructEntity(ServerPlayer player, @Nonnull TypeKeyword.Type type) {
        SpellEntity spell = new SpellEntity((LivingEntity)player, player.level());
        spell.setSpellType(type.getId());
        return spell;
    }

    public static void shootSpell(ServerPlayer player, SpellEntity spell) {
        spell.setOwner((Entity)player);
        spell.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
        if (spell.getSpellType() == 1) {
            spell.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 4.0f, 0.0f);
        } else {
            spell.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
        }
        player.level().playSound((Player)null, player.blockPosition(), (SoundEvent)SpelledRegistry.SHOOT_SPELL.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (player.level().random.nextFloat() * 0.4f + 1.2f) + 0.5f);
    }
}

