/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    private static final Predicate<Entity> defaultFilter = e -> EntitySelector.ENTITY_STILL_ALIVE.test(e) && EntitySelector.NO_SPECTATORS.test(e);

    public static <E extends Entity> HitResult getLookingAt(Class<E> clazz, Entity mainEntity, double distance, Predicate<E> entityPredicate) {
        Predicate<Entity> finalFilter = e -> e != mainEntity && defaultFilter.test((Entity)e) && e.isPickable() && entityPredicate.test(e);
        HitResult position = null;
        if (mainEntity.level() != null) {
            Vec3 look = mainEntity.getLookAngle().scale(distance);
            Vec3 from = mainEntity.position().add(0.0, (double)mainEntity.getEyeHeight(), 0.0);
            Vec3 to = from.add(look);
            position = RayTraceHelper.rayTraceBlocksAndEntities(clazz, mainEntity, from, to, finalFilter);
        }
        return position;
    }

    public static BlockHitResult rayTraceBlocks(Entity entity, Vec3 from, Vec3 to) {
        ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        return entity.getCommandSenderWorld().clip(context);
    }

    public static <E extends Entity> EntityHitResult rayTraceEntities(Class<E> clazz, Level level, Vec3 from, Vec3 to, Vec3 aaExpansion, float aaGrowth, float entityExpansion, Predicate<E> filter) {
        Predicate<Entity> predicate = input -> defaultFilter.test((Entity)input) && filter.test(input);
        Entity nearest = null;
        double distance = 0.0;
        AABB bb = new AABB(from, to).expandTowards(aaExpansion.x, aaExpansion.y, aaExpansion.z).inflate((double)aaGrowth);
        List entities = level.getEntitiesOfClass(clazz, bb, predicate);
        for (Entity entity : entities) {
            double dist;
            AABB entityBB = entity.getBoundingBox().inflate((double)entityExpansion);
            Optional intercept = entityBB.clip(from, to);
            if (!intercept.isPresent() || !((dist = from.distanceTo((Vec3)intercept.get())) < distance) && distance != 0.0) continue;
            nearest = entity;
            distance = dist;
        }
        if (nearest != null) {
            return new EntityHitResult(nearest);
        }
        return null;
    }

    private static <E extends Entity> HitResult rayTraceBlocksAndEntities(Class<E> clazz, Entity mainEntity, Vec3 from, Vec3 to, Predicate<E> entityFilter) {
        double entityDist;
        BlockHitResult block = RayTraceHelper.rayTraceBlocks(mainEntity, from, to);
        if (block.getType() == HitResult.Type.BLOCK) {
            to = block.getLocation();
        }
        EntityHitResult entity = RayTraceHelper.rayTraceEntities(clazz, mainEntity.getCommandSenderWorld(), from, to, Vec3.ZERO, 0.5f, 0.5f, entityFilter);
        if (block.getType() == HitResult.Type.MISS) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        double blockDist = block.getLocation().distanceTo(from);
        if (blockDist < (entityDist = entity.getLocation().distanceTo(from))) {
            return block;
        }
        return entity;
    }
}

