/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import com.mrbysco.spelled.config.ConfigCache;
import com.mrbysco.spelled.config.SpelledConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class LevelHelper {
    public static int getAllowedWordCount(int level) {
        return level > 0 ? level + 1 : 0;
    }

    public static ConfigCache.ItemCost getItemCost(int level) {
        return (Boolean)SpelledConfig.COMMON.individualItems.get() != false ? ConfigCache.individualLevelItemCosts.getOrDefault(level, new ConfigCache.ItemCost(ConfigCache.requiredItem, Math.min(10 + 2 * level, 64))) : new ConfigCache.ItemCost(ConfigCache.requiredItem, Math.min(10 + 2 * level, 64));
    }

    public static int getXPCost(int level) {
        int individualXPCost = ConfigCache.individualLevelXPCosts.getOrDefault(level, 5);
        int xpCost = (Integer)SpelledConfig.COMMON.xpMultiplier.get() * level;
        return (Boolean)SpelledConfig.COMMON.individualLevels.get() != false ? individualXPCost : xpCost;
    }

    public static void levelUpFailItems(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"spelled.level_up.fail_item").withStyle(ChatFormatting.GOLD), true);
    }

    public static void levelUpFailXP(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"spelled.level_up.fail_xp").withStyle(ChatFormatting.GOLD), true);
    }
}

