/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.server.level.ServerPlayer;

public class AdvancementHelper {
    public static void removeAllAdjectiveAdvancements(ServerPlayer player) {
        KeywordRegistry registry = KeywordRegistry.instance();
        for (String adjective : registry.getAdjectives()) {
            AdvancementHelper.lockAdjectiveAdvancement(player, adjective);
        }
        AdvancementHelper.lockAdvancement(player, "color_lore");
    }

    public static void unlockAdjectiveAdvancement(ServerPlayer player, String adjective) {
        AdvancementHelper.unlockAdvancement(player, "adjective_" + adjective);
        if (KeywordRegistry.instance().isColor(adjective) && AdvancementHelper.hasAllColors(player)) {
            AdvancementHelper.unlockAdvancement(player, "color_lore");
        }
    }

    public static void unlockAdvancement(ServerPlayer player, String name) {
        AdvancementProgress advancementprogress;
        AdvancementHolder advancementHolder = player.getServer().getAdvancements().get(Reference.modLoc(name));
        if (advancementHolder != null && !(advancementprogress = player.getAdvancements().getOrStartProgress(advancementHolder)).isDone()) {
            for (String s : advancementprogress.getRemainingCriteria()) {
                player.getAdvancements().award(advancementHolder, s);
            }
        }
    }

    public static void lockAdjectiveAdvancement(ServerPlayer player, String adjective) {
        AdvancementHelper.lockAdvancement(player, "adjective_" + adjective);
    }

    public static void lockAdvancement(ServerPlayer player, String name) {
        AdvancementProgress advancementprogress;
        AdvancementHolder advancementHolder = player.getServer().getAdvancements().get(Reference.modLoc(name));
        if (advancementHolder != null && (advancementprogress = player.getAdvancements().getOrStartProgress(advancementHolder)).hasProgress()) {
            for (String s : advancementprogress.getCompletedCriteria()) {
                player.getAdvancements().revoke(advancementHolder, s);
            }
        }
    }

    public static boolean hasAllColors(ServerPlayer player) {
        KeywordRegistry registry = KeywordRegistry.instance();
        boolean flag = true;
        for (String color : registry.getColors()) {
            AdvancementHolder advancementHolder = player.getServer().getAdvancements().get(Reference.modLoc("adjective_" + color));
            AdvancementProgress advancementprogress = player.getAdvancements().getOrStartProgress(advancementHolder);
            if (advancementprogress.isDone()) continue;
            flag = false;
            break;
        }
        return flag;
    }
}

