/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.keyword;

import com.mrbysco.spelled.api.keywords.BaseKeyword;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.entity.SpellEntity;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class TypeKeyword
extends BaseKeyword {
    private final Type type;

    public TypeKeyword(String keyword, Type type, int level, int slots) {
        super(keyword, level, slots);
        this.type = type;
    }

    @Override
    public void cast(Level level, ServerPlayer caster, SpellEntity spell, @Nullable IKeyword adjective) {
        if (spell != null) {
            spell.setSpellType(this.type.getId());
        }
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        BALL(0, "ball"),
        PROJECTILE(1, "projectile"),
        SELF(2, "self");

        private final String name;
        private final int id;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

