/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.keyword;

import com.mrbysco.spelled.api.keywords.BaseKeyword;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.registry.keyword.LiquidKeyword;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ColorKeyword
extends BaseKeyword {
    private final ChatFormatting color;

    public ColorKeyword(String keyword, ChatFormatting color, int level, int slots) {
        super(keyword, level, slots);
        this.color = color;
    }

    @Override
    public void cast(Level level, ServerPlayer caster, SpellEntity spell, @Nullable IKeyword adjective) {
        if (spell != null) {
            if ((adjective == null || adjective instanceof LiquidKeyword) && this.color == ChatFormatting.BLACK) {
                spell.setInky(true);
                spell.insertAction("ink");
            }
            if (this.color == ChatFormatting.AQUA && adjective instanceof LiquidKeyword) {
                spell.setWater(true);
                Color waterColor = new Color(0.2f, 0.3f, 1.0f);
                int colorID = waterColor.getRGB();
                if (spell.hasColor()) {
                    int currentColor = spell.getColor().getAsInt();
                    int combinedColor = (int)((float)currentColor * 0.5f + (float)colorID * 0.5f);
                    spell.setColor(combinedColor);
                } else {
                    spell.setColor(colorID);
                }
                spell.insertAction("water");
            } else {
                Integer colorID = this.color.getColor();
                if (colorID != null) {
                    if (spell.hasColor()) {
                        int currentColor = spell.getColor().getAsInt();
                        int combinedColor = (int)((float)currentColor * 0.5f + (float)colorID.intValue() * 0.5f);
                        spell.setColor(combinedColor);
                    } else {
                        spell.setColor(colorID);
                    }
                }
                if (adjective == null && this.color == ChatFormatting.WHITE) {
                    spell.insertAction("glow");
                }
            }
        }
    }
}

