/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.behavior;

import com.mrbysco.spelled.api.behavior.BaseBehavior;
import com.mrbysco.spelled.entity.SpellEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SnowBehavior
extends BaseBehavior {
    public SnowBehavior() {
        super("snow");
    }

    @Override
    public void onBlockHit(@Nonnull SpellEntity spell, BlockPos pos, BlockPos offPos) {
        Level level = spell.level();
        BlockState hitState = level.getBlockState(pos);
        BlockState offState = level.getBlockState(offPos);
        if (offState.getBlock() instanceof SnowLayerBlock && (Integer)offState.getValue((Property)SnowLayerBlock.LAYERS) < 8) {
            int layers = (Integer)offState.getValue((Property)SnowLayerBlock.LAYERS);
            level.setBlockAndUpdate(offPos, (BlockState)offState.getBlock().defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1)));
        } else if (hitState.getBlock() instanceof SnowLayerBlock && (Integer)hitState.getValue((Property)SnowLayerBlock.LAYERS) < 8) {
            int layers = (Integer)hitState.getValue((Property)SnowLayerBlock.LAYERS);
            level.setBlockAndUpdate(pos, (BlockState)hitState.getBlock().defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1)));
        } else {
            BlockState snowState = Blocks.SNOW.defaultBlockState();
            if (offState.canBeReplaced() && snowState.canSurvive((LevelReader)level, offPos)) {
                level.setBlockAndUpdate(offPos, snowState);
            }
        }
    }

    @Override
    public void onEntityHit(@Nonnull SpellEntity spell, Entity entity) {
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40));
        }
    }
}

