/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.behavior;

import com.mrbysco.spelled.api.behavior.BaseBehavior;
import com.mrbysco.spelled.entity.SpellEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class MatureBehavior
extends BaseBehavior {
    public MatureBehavior() {
        super("mature");
    }

    @Override
    public void onBlockHit(@Nonnull SpellEntity spell, BlockPos pos, BlockPos offPos) {
        Block block;
        Level level = spell.level();
        BlockPos abovePos = pos.above();
        BlockState aboveState = level.getBlockState(abovePos);
        int bonemealCount = 1 + spell.getPower();
        if (!level.isClientSide && (block = aboveState.getBlock()) instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            for (int i = 0; i < bonemealCount; ++i) {
                bonemealableBlock.performBonemeal((ServerLevel)level, level.random, abovePos, aboveState);
            }
        }
    }

    @Override
    public void onEntityHit(@Nonnull SpellEntity spell, Entity entity) {
        AgeableMob ageableMob;
        if (entity instanceof AgeableMob && (ageableMob = (AgeableMob)entity).isBaby()) {
            int age = ageableMob.getAge();
            ageableMob.ageUp(AgeableMob.getSpeedUpSecondsWhenFeeding((int)(-age)), true);
        }
    }
}

