/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.behavior;

import com.mrbysco.spelled.api.behavior.BaseBehavior;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.util.LootHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestBehavior
extends BaseBehavior {
    public HarvestBehavior() {
        super("harvest");
    }

    @Override
    public void onBlockHit(@Nonnull SpellEntity spell, BlockPos pos, BlockPos offPos) {
        boolean canBreak;
        Level level = spell.level();
        BlockState hitState = level.getBlockState(pos);
        float hardness = hitState.getDestroySpeed((BlockGetter)level, pos);
        float power = 1.0f + (float)spell.getPower();
        Entity entity = spell.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            v0 = hitState.canHarvestBlock((BlockGetter)level, pos, player);
        } else {
            v0 = canBreak = false;
        }
        if (!level.isClientSide && canBreak && hardness <= power && hitState.getBlock().getExplosionResistance() <= 1200.0f) {
            if (spell.isSilky()) {
                level.getBlockState(pos).getDrops(LootHelper.silkContextBuilder((ServerLevel)level, pos, spell)).forEach(i -> level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), i)));
                level.destroyBlock(pos, false);
            } else {
                level.destroyBlock(pos, true);
            }
        }
    }

    @Override
    public void onEntityHit(@Nonnull SpellEntity spell, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                ItemStack stack = livingEntity.getItemBySlot(slotType);
                if (!livingEntity.getRandom().nextBoolean() || stack.isEmpty()) continue;
                int power = 1 + spell.getPower();
                stack.hurtAndBreak(power, livingEntity, slotType);
                break;
            }
        }
    }
}

