/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.behavior;

import com.mrbysco.spelled.api.behavior.BaseBehavior;
import com.mrbysco.spelled.entity.SpellEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ExtinguishBehavior
extends BaseBehavior {
    public ExtinguishBehavior() {
        super("extinguish");
    }

    @Override
    public void onBlockHit(@Nonnull SpellEntity spell, BlockPos pos, BlockPos offPos) {
        Level level = spell.level();
        this.extinguishFires(level, pos);
        this.extinguishFires(level, offPos);
    }

    private void extinguishFires(Level level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(BlockTags.FIRE)) {
            level.levelEvent((Player)null, 1009, pos, 0);
            level.removeBlock(pos, false);
        } else if (CampfireBlock.isLitCampfire((BlockState)blockstate)) {
            level.levelEvent((Player)null, 1009, pos, 0);
            CampfireBlock.dowse(null, (LevelAccessor)level, (BlockPos)pos, (BlockState)blockstate);
            level.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.FALSE));
        }
    }

    @Override
    public void onEntityHit(@Nonnull SpellEntity spell, Entity entity) {
        Level level = entity.level();
        level.playSound((Player)null, entity.blockPosition(), SoundEvents.GENERIC_EXTINGUISH_FIRE, entity.getSoundSource(), 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
        entity.clearFire();
    }
}

