/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry;

import com.mojang.serialization.Codec;
import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.attachment.SpellData;
import com.mrbysco.spelled.block.LevelingAltarBlock;
import com.mrbysco.spelled.blockentity.LevelingAltarBlockEntity;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.item.CreativeTomeItem;
import com.mrbysco.spelled.item.SpellbookItem;
import com.mrbysco.spelled.item.TomeItem;
import com.mrbysco.spelled.menu.AltarMenu;
import com.mrbysco.spelled.registry.SpelledComponents;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SpelledRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"spelled");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"spelled");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"spelled");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"spelled");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"spelled");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"spelled");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"spelled");
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"spelled");
    public static final DeferredHolder<SoundEvent, SoundEvent> SHOOT_SPELL = SOUND_EVENTS.register("shoot.spell", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Reference.modLoc("shoot.spell")));
    public static final DeferredBlock<LevelingAltarBlock> LEVELING_ALTAR = BLOCKS.register("leveling_altar", () -> new LevelingAltarBlock(BlockBehaviour.Properties.of().strength(2.5f).sound(SoundType.WOOD)));
    public static final DeferredItem<BlockItem> LEVELING_ALTAR_ITEM = ITEMS.register("leveling_altar", () -> new BlockItem((Block)LEVELING_ALTAR.get(), SpelledRegistry.itemBuilder()));
    public static final DeferredItem<TomeItem> KNOWLEDGE_TOME = ITEMS.register("ancient_knowledge_tome", () -> new TomeItem(SpelledRegistry.itemBuilder()));
    public static final DeferredItem<CreativeTomeItem> CREATIVE_TOME = ITEMS.register("creative_tome", () -> new CreativeTomeItem(SpelledRegistry.itemBuilder()));
    public static final DeferredItem<SpellbookItem> SPELL_BOOK = ITEMS.register("spell_book", () -> new SpellbookItem(SpelledRegistry.itemBuilder().stacksTo(1)));
    public static final Supplier<BlockEntityType<LevelingAltarBlockEntity>> LEVELING_ALTAR_TILE = BLOCK_ENTITY_TYPES.register("leveling_altar_tile", () -> BlockEntityType.Builder.of(LevelingAltarBlockEntity::new, (Block[])new Block[]{(Block)LEVELING_ALTAR.get()}).build(null));
    public static final Supplier<MenuType<AltarMenu>> ALTAR_CONTAINER = MENU_TYPES.register("leveling_altar", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AltarMenu(windowId, inv)));
    public static final Supplier<EntityType<SpellEntity>> SPELL = ENTITY_TYPES.register("spell", () -> SpelledRegistry.register("spell", EntityType.Builder.of(SpellEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(20)));
    public static final Supplier<AttachmentType<SpellData>> SPELL_DATA_ATTACHMENT = ATTACHMENT_TYPES.register("spell_data", () -> AttachmentType.serializable(SpellData::new).build());
    public static final Supplier<AttachmentType<Boolean>> HAS_BOOK_ATTACHMENT = ATTACHMENT_TYPES.register("has_book", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).copyOnDeath().build());
    public static final Supplier<CreativeModeTab> SPELLED_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)LEVELING_ALTAR_ITEM.get())).title((Component)Component.translatable((String)"itemGroup.spelled.tab")).displayItems((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.acceptAll(stacks);
        for (String adjective : KeywordRegistry.instance().getAdjectives()) {
            ItemStack stack = KNOWLEDGE_TOME.toStack();
            stack.set(SpelledComponents.UNLOCK, (Object)adjective);
            output.accept(stack);
        }
    }).build());

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.build(id);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }
}

