/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.packets.handler;

import com.mrbysco.spelled.packets.message.SignSpellPayload;
import com.mrbysco.spelled.registry.SpelledComponents;
import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSignSpell(SignSpellPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                int slot;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack book = data.book();
                if (book.getItem() == SpelledRegistry.SPELL_BOOK.get() && (Inventory.isHotbarSlot((int)(slot = data.slot())) || slot == 40)) {
                    boolean signing = data.signing();
                    if (signing) {
                        this.signBook((Player)player, data.title(), data.spell(), slot);
                    } else {
                        this.updateBookContents((Player)player, data.spell(), slot);
                    }
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"statues.networking.player_statue_sync.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    private void updateBookContents(Player player, String spell, int slot) {
        ItemStack stack = player.getInventory().getItem(slot);
        if (stack.getItem() == SpelledRegistry.SPELL_BOOK.get()) {
            stack.set(SpelledComponents.SPELL, (Object)spell);
        }
    }

    private void signBook(Player player, String title, String spell, int index) {
        ItemStack itemstack = player.getInventory().getItem(index);
        if (itemstack.getItem() == SpelledRegistry.SPELL_BOOK.get()) {
            ItemStack stack = itemstack.transmuteCopy((ItemLike)SpelledRegistry.SPELL_BOOK.get());
            stack.remove(DataComponents.WRITABLE_BOOK_CONTENT);
            ArrayList list = new ArrayList();
            stack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(this.filterableFromOutgoing(player, FilteredText.passThrough((String)title)), player.getName().getString(), 0, list, true));
            stack.set(SpelledComponents.SPELL, (Object)spell);
            stack.set(SpelledComponents.SEALED, (Object)true);
            player.getInventory().setItem(index, stack);
        }
    }

    private Filterable<String> filterableFromOutgoing(Player player, FilteredText filteredText) {
        return player.isTextFilteringEnabled() ? Filterable.passThrough((Object)filteredText.filteredOrEmpty()) : Filterable.from((FilteredText)filteredText);
    }
}

