/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.packets.handler;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.packets.message.SpellDataSyncPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSync(SpellDataSyncPayload data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = Minecraft.getInstance().level.getPlayerByUUID(data.playerUUID());
            if (player != null) {
                SpelledAPI.getSpellDataCap(player).ifPresent(sanityCap -> sanityCap.deserializeNBT((HolderLookup.Provider)player.registryAccess(), (Tag)data.data()));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"spelled.networking.spell_data_sync.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

