/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.menu;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.config.ConfigCache;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.menu.AltarSlot;
import com.mrbysco.spelled.registry.SpelledRegistry;
import com.mrbysco.spelled.util.LevelHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AltarMenu
extends AbstractContainerMenu {
    private final Container tableInventory = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            AltarMenu.this.slotsChanged((Container)this);
        }
    };
    private final ContainerLevelAccess worldPosCallable;
    public final int[] currentLevel = new int[1];
    public final int[] levelCosts;
    public final int[] itemAmountCosts;
    public final Item[] itemCosts;

    public AltarMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.NULL, 0);
    }

    public AltarMenu(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable, int currentLevel) {
        super(SpelledRegistry.ALTAR_CONTAINER.get(), id);
        this.levelCosts = new int[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.itemAmountCosts = new int[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.itemCosts = new Item[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.worldPosCallable = worldPosCallable;
        this.currentLevel[0] = currentLevel;
        this.addDataSlot(DataSlot.shared((int[])this.currentLevel, (int)0));
        for (int level = 0; level < (Integer)SpelledConfig.COMMON.maxLevel.get(); ++level) {
            this.levelCosts[level] = LevelHelper.getXPCost(level + 1);
            ConfigCache.ItemCost cost = LevelHelper.getItemCost(level + 1);
            this.itemAmountCosts[level] = cost.getCost();
            this.itemCosts[level] = cost.getItem();
            this.addDataSlot(DataSlot.shared((int[])this.levelCosts, (int)level));
            this.addDataSlot(DataSlot.shared((int[])this.itemAmountCosts, (int)level));
        }
        if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue()) {
            this.addSlot(new AltarSlot(playerInventory.player, this.tableInventory, 0, 80, 56));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public int getCostStackCount() {
        ItemStack itemstack = this.tableInventory.getItem(0);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    private boolean hasXP(Player playerIn, int level) {
        int XPCost = this.levelCosts[level];
        return ((Boolean)SpelledConfig.COMMON.individualLevels.get()).booleanValue() ? playerIn.experienceLevel >= XPCost : playerIn.totalExperience >= XPCost;
    }

    public int getCurrentLevel() {
        return this.currentLevel[0];
    }

    public int getCurrentLevelCost() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.levelCosts.length) {
            return this.levelCosts[currentLevel];
        }
        return -1;
    }

    public int getItemCostAmount() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.itemAmountCosts.length) {
            return this.itemAmountCosts[currentLevel];
        }
        return -1;
    }

    public Item getItemCost() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.itemCosts.length) {
            return this.itemCosts[currentLevel];
        }
        return Items.AIR;
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        int level = this.currentLevel[0];
        int newLevel = level + 1;
        int XPCost = this.levelCosts[level];
        if (level >= (Integer)SpelledConfig.COMMON.maxLevel.get() || !this.hasXP(playerIn, level) && !playerIn.getAbilities().instabuild) {
            if (!this.hasXP(playerIn, level)) {
                LevelHelper.levelUpFailXP(playerIn);
            }
            return false;
        }
        if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue()) {
            ItemStack stack = this.tableInventory.getItem(0);
            ConfigCache.ItemCost itemCost = LevelHelper.getItemCost(newLevel);
            if (stack.isEmpty() || stack.getItem() != itemCost.getItem() && stack.getCount() < itemCost.getCost()) {
                LevelHelper.levelUpFailItems(playerIn);
                return false;
            }
            this.worldPosCallable.execute((p_217003_6_, p_217003_7_) -> {
                this.useLevels(playerIn, XPCost);
                if (!playerIn.getAbilities().instabuild) {
                    stack.shrink(itemCost.getCost());
                    if (stack.isEmpty()) {
                        this.tableInventory.setItem(0, ItemStack.EMPTY);
                    }
                }
                this.tableInventory.setChanged();
                this.slotsChanged(this.tableInventory);
                p_217003_6_.playSound((Player)null, p_217003_7_, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, p_217003_6_.random.nextFloat() * 0.1f + 0.9f);
                SpelledAPI.forceSetLevel((Player)((ServerPlayer)playerIn), newLevel);
                SpelledAPI.syncCap((ServerPlayer)playerIn);
                this.currentLevel[0] = newLevel;
            });
            return true;
        }
        this.useLevels(playerIn, XPCost);
        SpelledAPI.forceSetLevel((Player)((ServerPlayer)playerIn), newLevel);
        SpelledAPI.syncCap((ServerPlayer)playerIn);
        this.currentLevel[0] = newLevel;
        return true;
    }

    public void useLevels(Player playerIn, int XPCost) {
        if (((Boolean)SpelledConfig.COMMON.individualLevels.get()).booleanValue()) {
            playerIn.giveExperienceLevels(-XPCost);
        } else {
            playerIn.giveExperiencePoints(-XPCost);
        }
        if (playerIn.experienceLevel < 0) {
            playerIn.experienceLevel = 0;
            playerIn.experienceProgress = 0.0f;
            playerIn.totalExperience = 0;
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.worldPosCallable.execute((level, pos) -> this.clearContainer(playerIn, this.tableInventory));
    }

    public boolean stillValid(Player playerIn) {
        return AltarMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)SpelledRegistry.LEVELING_ALTAR.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0 ? !this.moveItemStackTo(itemstack1, 2, 37, true) : (index == 1 ? !this.moveItemStackTo(itemstack1, 2, 37, true) : !this.moveItemStackTo(itemstack1, 0, 1, true))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }
}

