/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.item;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.registry.SpelledComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TomeItem
extends Item {
    public TomeItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (!level.isClientSide) {
            ItemStack itemstack = playerIn.getItemInHand(handIn);
            if (itemstack.has(SpelledComponents.UNLOCK)) {
                Optional<ISpellData> cap = SpelledAPI.getSpellDataCap(playerIn);
                ISpellData data = cap.orElseGet(null);
                if (cap.isPresent()) {
                    String word = (String)itemstack.getOrDefault(SpelledComponents.UNLOCK, (Object)"");
                    if (!data.knowsKeyword(word)) {
                        playerIn.startUsingItem(handIn);
                        SpelledAPI.unlockKeyword((Player)((ServerPlayer)playerIn), word);
                        SpelledAPI.syncCap((ServerPlayer)playerIn);
                        playerIn.displayClientMessage((Component)Component.translatable((String)"spelled.tome.success"), true);
                        return InteractionResultHolder.consume((Object)itemstack);
                    }
                    playerIn.displayClientMessage((Component)Component.translatable((String)"spelled.tome.fail"), true);
                    return InteractionResultHolder.fail((Object)itemstack);
                }
            } else {
                String adjective = KeywordRegistry.instance().getRandomAdjective();
                if (!adjective.isEmpty()) {
                    itemstack.set(SpelledComponents.UNLOCK, (Object)KeywordRegistry.instance().getRandomAdjective());
                }
            }
        }
        return super.use(level, playerIn, handIn);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!((Boolean)SpelledConfig.COMMON.hideKnowledgeTomeInfo.get()).booleanValue()) {
            if (stack.has(SpelledComponents.UNLOCK)) {
                String word = (String)stack.getOrDefault(SpelledComponents.UNLOCK, (Object)"");
                tooltip.add((Component)Component.translatable((String)"spelled.tome.description", (Object[])new Object[]{Component.literal((String)word).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)Component.translatable((String)"spelled.tome.description.invalid").withStyle(ChatFormatting.RED));
            }
        }
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

