/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.item;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.client.ClientHelper;
import com.mrbysco.spelled.client.gui.book.AdjectiveEntry;
import com.mrbysco.spelled.registry.SpelledComponents;
import com.mrbysco.spelled.util.SpellUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;

public class SpellbookItem
extends Item {
    public SpellbookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.has(SpelledComponents.SEALED)) {
            if (!level.isClientSide) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String message = (String)stack.getOrDefault(SpelledComponents.SPELL, (Object)"");
                String regExp = "^[a-zA-Z\\s]*$";
                if (!message.isEmpty() && message.matches("^[a-zA-Z\\s]*$")) {
                    MutableComponent component = Component.translatable((String)"chat.type.text", (Object[])new Object[]{serverPlayer.getDisplayName(), CommonHooks.newChatWithLinks((String)message)});
                    if ((component = SpellUtil.manualCastSpell(serverPlayer, message, (Component)component)) == null) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    serverPlayer.getServer().getPlayerList().broadcastSystemMessage((Component)component, true);
                }
            }
        } else if (level.isClientSide) {
            ArrayList<AdjectiveEntry> adjectives = new ArrayList<AdjectiveEntry>();
            SpelledAPI.getUnlocks(player).forEach(adjective -> {
                IKeyword word;
                if (!adjective.isEmpty() && (word = KeywordRegistry.instance().getKeywordFromName((String)adjective)) != null) {
                    adjectives.add(new AdjectiveEntry(word, word.getKeyword(), word.getDescription(), word.getSlots()));
                }
            });
            if (adjectives.isEmpty()) {
                player.sendSystemMessage((Component)Component.translatable((String)"spelled.spell_book.insufficient"));
            } else {
                KeywordRegistry.instance().getTypes().forEach(adjective -> {
                    IKeyword word = KeywordRegistry.instance().getKeywordFromName((String)adjective);
                    adjectives.add(new AdjectiveEntry(word, word.getKeyword(), word.getDescription(), word.getSlots()));
                });
                ClientHelper.openSpellBookScreen(adjectives, hand, player);
            }
        }
        return super.use(level, player, hand);
    }

    public Component getName(ItemStack stack) {
        String s;
        WrittenBookContent writtenbookcontent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenbookcontent != null && !StringUtil.isBlank((String)(s = (String)writtenbookcontent.title().raw()))) {
            return Component.literal((String)s);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        WrittenBookContent writtenbookcontent = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenbookcontent != null && !StringUtil.isBlank((String)writtenbookcontent.author())) {
            tooltipComponents.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{writtenbookcontent.author()}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(SpelledComponents.SEALED);
    }
}

