/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.item;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CreativeTomeItem
extends Item {
    public CreativeTomeItem(Item.Properties builder) {
        super(builder.rarity(Rarity.EPIC));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        if (!level.isClientSide) {
            ItemStack itemstack = playerIn.getItemInHand(handIn);
            playerIn.startUsingItem(handIn);
            ArrayList<String> adjectives = KeywordRegistry.instance().getAdjectives();
            for (String adjective : adjectives) {
                SpelledAPI.unlockKeyword(playerIn, adjective);
            }
            SpelledAPI.syncCap((ServerPlayer)playerIn);
            playerIn.displayClientMessage((Component)Component.translatable((String)"spelled.tome.success"), true);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return super.use(level, playerIn, handIn);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"spelled.creative_tome.description").withStyle(ChatFormatting.DARK_PURPLE));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

