/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.handler;

import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.registry.SpelledComponents;
import com.mrbysco.spelled.registry.SpelledRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import vazkii.patchouli.common.item.PatchouliDataComponents;

public class LootHandler {
    private static final String hasBookTag = "spelled::hasBook";

    @SubscribeEvent
    public void firstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide && ((Boolean)SpelledConfig.COMMON.startWithBook.get()).booleanValue()) {
            CompoundTag playerData = player.getPersistentData();
            if (!player.hasData(SpelledRegistry.HAS_BOOK_ATTACHMENT)) {
                if (playerData.getBoolean(hasBookTag)) {
                    player.setData(SpelledRegistry.HAS_BOOK_ATTACHMENT, (Object)true);
                    return;
                }
                Item guideBook = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"guide_book"));
                if (guideBook != null) {
                    ItemStack guideStack = new ItemStack((ItemLike)guideBook);
                    guideStack.set(PatchouliDataComponents.BOOK, (Object)Reference.modLoc("knowledge_tome"));
                    player.addItem(guideStack);
                    player.setData(SpelledRegistry.HAS_BOOK_ATTACHMENT, (Object)true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "stronghold_library": 
                case "jungle_temple": 
                case "underwater_ruin_big": 
                case "end_city_treasure": 
                case "buried_treasure": 
                case "woodland_mansion": 
                case "bastion_treasure": 
                case "village_cartographer": {
                    event.getTable().addPool(LootHandler.getInjectPool());
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool() {
        LootPool.Builder builder = LootPool.lootPool();
        KeywordRegistry registry = KeywordRegistry.instance();
        if (registry.getAdjectives().isEmpty()) {
            registry.initializeKeywords();
        }
        for (String adjective : registry.getAdjectives()) {
            builder.add(LootHandler.injectTome(adjective));
        }
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(1));
        builder.setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).name("spelled_inject");
        return builder.build();
    }

    private static LootPoolEntryContainer.Builder injectTome(String adjective) {
        LootPoolSingletonContainer.Builder entry = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get())).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(SpelledComponents.UNLOCK.get(), (Object)adjective)).when(LootItemRandomChanceCondition.randomChance((float)0.2f))).setWeight(1);
        return entry;
    }

    @SubscribeEvent
    public void onWandererTradesEvent(WandererTradesEvent event) {
        KeywordRegistry registry = KeywordRegistry.instance();
        if (registry.getAdjectives().isEmpty()) {
            registry.initializeKeywords();
        }
        ItemStack stack = new ItemStack((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get());
        for (String adjective : registry.getAdjectives()) {
            IKeyword keyword = registry.getKeywordFromName(adjective);
            if (keyword == null) continue;
            event.getRareTrades().add(new ItemsForEmeraldsTrade(stack, keyword.getLevel() + 2, 1, adjective, 1, keyword.getLevel()));
        }
    }

    public static class ItemsForEmeraldsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack outputStack;
        private final int outputAmount;
        private final String unlock;
        private final int priceAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(ItemStack outputStack, int priceAmount, int outputAmount, String unlock, int maxUses, int givenExp) {
            this(outputStack, priceAmount, outputAmount, unlock, maxUses, givenExp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack outputStack, int priceAmount, int outputAmount, String unlock, int maxUses, int givenExp, float priceMultiplier) {
            this.priceAmount = priceAmount;
            this.outputStack = outputStack;
            this.outputAmount = outputAmount;
            this.unlock = unlock;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer getOffer(Entity trader, RandomSource rand) {
            ItemStack stack = new ItemStack((ItemLike)this.outputStack.getItem(), this.outputAmount);
            stack.set(SpelledComponents.UNLOCK.get(), (Object)this.unlock);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.priceAmount), stack, this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }
}

