/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.generator.data;

import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class SpelledAdvancements
extends AdvancementProvider {
    private static final List<AdvancementProvider.AdvancementGenerator> subproviders = List.of(new SpelledAdvancementGenerator());

    public SpelledAdvancements(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, existingFileHelper, subproviders);
    }

    public static class SpelledAdvancementGenerator
    implements AdvancementProvider.AdvancementGenerator {
        public AdvancementHolder root;
        public AdvancementHolder color_lore;
        public AdvancementHolder ater;
        public AdvancementHolder aureus;
        public AdvancementHolder caeruleus;
        public AdvancementHolder viridis;
        public AdvancementHolder aqua;
        public AdvancementHolder rubrum;
        public AdvancementHolder roseus;
        public AdvancementHolder flavus;
        public AdvancementHolder albus;
        public AdvancementHolder parvus;
        public AdvancementHolder magnum;
        public AdvancementHolder grandis;
        public AdvancementHolder immanis;
        public AdvancementHolder liquidus;
        public AdvancementHolder nix;
        public AdvancementHolder frigus;
        public AdvancementHolder dissiliunt;
        public AdvancementHolder sanitatem;
        public AdvancementHolder nocere;
        public AdvancementHolder praesidium;
        public AdvancementHolder fractionis;
        public AdvancementHolder propellentibus;
        public AdvancementHolder ignis;
        public AdvancementHolder vis;
        public AdvancementHolder sericum;
        public AdvancementHolder maturis;

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            this.root = Advancement.Builder.advancement().display((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.translatable((String)"advancement.spelled.root"), (Component)Component.translatable((String)"advancement.spelled.root.desc"), ResourceLocation.withDefaultNamespace((String)"textures/block/bookshelf.png"), AdvancementType.TASK, true, false, false).addCriterion("air", EnterBlockTrigger.TriggerInstance.entersBlock((Block)Blocks.AIR)).save(consumer, "spelled:root");
            this.color_lore = Advancement.Builder.advancement().display((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.translatable((String)"advancement.spelled.color_lore"), (Component)Component.translatable((String)"advancement.spelled.color_lore.desc"), null, AdvancementType.TASK, false, false, false).parent(this.root).addCriterion("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, "spelled:color_lore");
            this.ater = this.generateAdjectiveAdvancement("ater", this.color_lore, consumer);
            this.aureus = this.generateAdjectiveAdvancement("aureus", this.ater, consumer);
            this.caeruleus = this.generateAdjectiveAdvancement("caeruleus", this.aureus, consumer);
            this.viridis = this.generateAdjectiveAdvancement("viridis", this.caeruleus, consumer);
            this.aqua = this.generateAdjectiveAdvancement("aqua", this.viridis, consumer);
            this.rubrum = this.generateAdjectiveAdvancement("rubrum", this.aqua, consumer);
            this.roseus = this.generateAdjectiveAdvancement("roseus", this.rubrum, consumer);
            this.flavus = this.generateAdjectiveAdvancement("flavus", this.roseus, consumer);
            this.albus = this.generateAdjectiveAdvancement("albus", this.flavus, consumer);
            this.parvus = this.generateAdjectiveAdvancement("parvus", this.root, consumer);
            this.magnum = this.generateAdjectiveAdvancement("magnum", this.parvus, consumer);
            this.grandis = this.generateAdjectiveAdvancement("grandis", this.magnum, consumer);
            this.immanis = this.generateAdjectiveAdvancement("immanis", this.grandis, consumer);
            this.liquidus = this.generateAdjectiveAdvancement("liquidus", this.root, consumer);
            this.nix = this.generateAdjectiveAdvancement("nix", this.liquidus, consumer);
            this.frigus = this.generateAdjectiveAdvancement("frigus", this.nix, consumer);
            this.dissiliunt = this.generateAdjectiveAdvancement("dissiliunt", this.frigus, consumer);
            this.sanitatem = this.generateAdjectiveAdvancement("sanitatem", this.dissiliunt, consumer);
            this.nocere = this.generateAdjectiveAdvancement("nocere", this.sanitatem, consumer);
            this.praesidium = this.generateAdjectiveAdvancement("praesidium", this.nocere, consumer);
            this.fractionis = this.generateAdjectiveAdvancement("fractionis", this.praesidium, consumer);
            this.propellentibus = this.generateAdjectiveAdvancement("propellentibus", this.fractionis, consumer);
            this.ignis = this.generateAdjectiveAdvancement("ignis", this.propellentibus, consumer);
            this.vis = this.generateAdjectiveAdvancement("vis", this.fractionis, consumer);
            this.sericum = this.generateAdjectiveAdvancement("sericum", this.vis, consumer);
            this.maturis = this.generateAdjectiveAdvancement("maturis", this.praesidium, consumer);
        }

        private AdvancementHolder generateAdjectiveAdvancement(String adjective, AdvancementHolder parent, Consumer<AdvancementHolder> consumer) {
            return Advancement.Builder.advancement().display((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.translatable((String)String.format("advancement.spelled.%s", adjective)), (Component)Component.translatable((String)String.format("advancement.spelled.%s.desc", adjective)), null, AdvancementType.TASK, false, false, false).parent(parent).addCriterion("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, "spelled:adjective_" + adjective);
        }
    }
}

