/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.entity;

import com.mrbysco.spelled.api.behavior.BehaviorRegistry;
import com.mrbysco.spelled.api.behavior.ISpellBehavior;
import com.mrbysco.spelled.entity.AbstractSpellEntity;
import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class SpellEntity
extends AbstractSpellEntity {
    public SpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpellEntity(LivingEntity shooter, Level level) {
        super(SpelledRegistry.SPELL.get(), shooter, level);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().addParticle(this.getTrailParticle(), this.getX(), this.getY(), this.getZ(), 1.0, 0.0, 0.0);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult entityResult) {
        super.onHitEntity(entityResult);
        Entity hitEntity = entityResult.getEntity();
        this.handleEntityHit(hitEntity);
    }

    public void handleEntityHit(Entity hitEntity) {
        List<Entity> rangedEntities = this.getRangedEntities(hitEntity);
        HashMap<String, ISpellBehavior> behaviors = BehaviorRegistry.instance().getBehaviors();
        for (int i = 0; i < this.getSpellOrder().size(); ++i) {
            String action = this.getSpellOrder().getString(String.valueOf(i));
            ISpellBehavior behavior = behaviors.get(action);
            if (behavior == null) continue;
            if (behavior.appliedMultiple()) {
                for (Entity entity : rangedEntities) {
                    behavior.onEntityHit(this, entity);
                }
                continue;
            }
            behavior.onEntityHit(this, hitEntity);
        }
    }

    protected void onHitBlock(BlockHitResult blockResult) {
        super.onHitBlock(blockResult);
        BlockPos pos = blockResult.getBlockPos();
        List<BlockPos> multiplePos = this.getSizedPos(pos);
        HashMap<String, ISpellBehavior> behaviors = BehaviorRegistry.instance().getBehaviors();
        for (int i = 0; i < this.getSpellOrder().size(); ++i) {
            String action = this.getSpellOrder().getString(String.valueOf(i));
            ISpellBehavior behavior = behaviors.get(action);
            if (behavior == null) continue;
            if (behavior.appliedMultiple()) {
                for (BlockPos boxPos : multiplePos) {
                    behavior.onBlockHit(this, boxPos, boxPos.relative(blockResult.getDirection()));
                }
                continue;
            }
            behavior.onBlockHit(this, pos, pos.relative(blockResult.getDirection()));
        }
    }
}

